/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class AiffInputStream
extends InputStream {
    private static final int BUFSIZE = 2048;
    private RandomAccessFile raf;
    private byte[] fileBuf;
    private int fileBufSize;
    private int fileBufOffset;
    private boolean eof;

    public AiffInputStream(RandomAccessFile raf) {
        this.raf = raf;
        this.eof = false;
        this.fileBuf = new byte[2048];
        this.fileBufSize = 0;
        this.fileBufOffset = 0;
    }

    @Override
    public int read() throws IOException {
        while (!this.eof) {
            if (this.fileBufOffset < this.fileBufSize) {
                return this.fileBuf[this.fileBufOffset++] & 0xFF;
            }
            this.fillBuf();
        }
        return -1;
    }

    private void fillBuf() throws IOException {
        int bytesRead = this.raf.read(this.fileBuf, 0, 2048);
        this.fileBufOffset = 0;
        this.fileBufSize = bytesRead;
        if (this.fileBufSize == 0) {
            this.eof = true;
        }
    }
}

